# -*- coding: utf-8 -*-
"""
Created on Tue May 21 14:40:29 2019

@author: adijkstra
"""
"""
NOTE!!!! THIS CODE ONLY WORKS WHEN YOUR X-AXIS DATA IS EQUALLY SPACED
"""

import numpy as np
from numpy import exp, linspace, random
import pandas as pd
import matplotlib.pyplot as plt
import os
from scipy.optimize import curve_fit
from scipy.special import gamma
from scipy import signal
from scipy.ndimage import convolve1d
from scipy.ndimage import correlate1d

#============Get the current directory
path = os.getcwd()
print("The current directory is: %s" % path )
#==================================================================


#specify from which file the data comes
#fileNameTemp ='H06138_LICorrIntensityTemperatures.txt'
fileNameCounts = 'Si2Ge8_countRate_Temperatures.txt'
fileNameNormCounts = 'Si2Ge8_normalized_countRate_Temperatures.txt'
importedFileCounts = np.array(pd.read_csv(fileNameCounts, sep='\t', header=None))
importedFileNormCounts = np.array(pd.read_csv(fileNameNormCounts, sep='\t', header=None))

#Get all the variables as float strings
tDelayData = importedFileCounts[10:,0].astype(np.float)
Counts = importedFileCounts[10:,1:].astype(np.float)
NormCounts = importedFileNormCounts[10:,1:].astype(np.float)
IntTime = importedFileNormCounts[7,1:].astype(np.float)
Power = importedFileNormCounts[6,1:].astype(np.float)
NW = importedFileNormCounts[8,1:].astype(np.float)
NWsub = importedFileNormCounts[9,1:].astype(np.float)
Temperature = importedFileNormCounts[3,1:].astype(np.float)


#Check the number of imported spectra
importSize = np.size(importedFileCounts[:1])-1

#initialize the arrays for baseline correction, here they are not corrected yet
BScorr_Counts = Counts
BScorr_normCounts = NormCounts
Baselines = np.zeros(importSize)
BaselinesNorm = np.zeros(importSize)


#Start the baseline correction by averageing the last part of the array and substracting from the whole
for temp in range (0, importSize):
    Baselines[temp]=np.average(BScorr_Counts[4000:,temp])
    BaselinesNorm[temp]=np.average(BScorr_normCounts[4000:,temp])
    BScorr_Counts[:,temp] =  np.subtract(BScorr_Counts[:,temp],Baselines[temp])
    #subtract the baseline from the normalized data and renormalize
    BScorr_normCounts[:,temp] = BScorr_normCounts[:,temp] - BaselinesNorm[temp]
    BScorr_normCounts[:,temp] = np.divide(BScorr_normCounts[:,temp],np.amax(BScorr_normCounts[:,temp]))

print(Baselines)

#Because of some sort pf bug I have te reimport these values!!!! I relly don't get the problem
Counts = importedFileCounts[10:,1:].astype(np.float)
NormCounts = importedFileNormCounts[10:,1:].astype(np.float)

measurement=0





"""
========================================================
=============Define the Functions for Fitting===========
========================================================
"""

def ExpDecay(t, tau, A, t0=11500, y0=0, normalized=False):
    if normalized == False:
        return y0 + np.multiply(A,np.exp(-np.divide((t-t0),tau)))
    elif normalized == True:
        temp = y0 + np.multiply(A,np.exp(-np.divide((t-t0),tau)))
        return np.divide(temp,np.amax(temp))

"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""

#This is a scale I use to get a higher density of data points
tDelaySimu = np.arange(0, 25000, 1)
tDelaySimu = tDelaySimu.astype(np.float)

tau=500
y0=0
A=20
t0=11500

  
"""
#Plot the normalized graphs to show what I am working with
plt.figure(figsize=(6,6))
#plt.subplot(1,2,1)
plt.semilogy(np.divide(tDelayData,1000), BScorr_Counts[:,measurement],'b', label="after BL correction")
plt.semilogy(np.divide(tDelayData,1000), Counts[:,measurement],'r', label="before BL correction")
plt.legend(loc="best")
#plt.semilogy(tDelaySimu, ExpDecay(tDelaySimu, tau, A, t0,  y0), 'g')
plt.axis([10, 18, 0.05 ,30])
#plt.subplot(1,2,2)
#plt.semilogy(tDelaySimu, ExpDecay(tDelaySimu, tau, A, t0, y0), 'g')
#plt.semilogy(tDelayData, Counts[:,6], 'b^')
#plt.axis([10000, 15000, 0.05 ,30])
plt.show()
"""


"""
==================================================
===============SET THE VARIABLES==================
==================================================
"""



###############################################################
#Fitting with a single exponential
#NW dependent
####################################################


#==================Setting fitting parameters
SEtau=500
SEy0=0
SEA=20
SEt0=11500

FitStartElement=2850
FitEndElement=3300

IntStartElement=2680
IntEndElement=4300


#Choose whether to fit the data or simply import it from the previous file
FIT_DATA=False
PRINT_PLOTS=False
SAVE_AVERAGED=True
#============================

#make a new directory of all the output of the PL_V_T data
path = os.getcwd()
print("The current directory is: %s" % path )
newnewfolderpath=path+"/TRPL_singleExp_NW-series"
try:
    os.mkdir(newnewfolderpath)
except OSError:
    print('Creation of folder failed')
else:
    print('Succesfully created folder')
try:
    os.chdir(newnewfolderpath)
except OSError:
    print('Failed to change directories to new folder')
else:    
    print('Changed directory to new new folder: ' + newnewfolderpath)

#Check how many things I imported
importSize=np.size(importedFileCounts[:1])-1

#Make result arrays existing out of zeros
results_singleExp_TRPL = np.zeros(((importSize),11),dtype=float)

#Make initial values
#InVal_singleExp_TRPL = [SEtau, SEA, SEt0, SEy0]  # for [amp, cen, wid]
InVal_singleExp_TRPL = [SEtau, SEA]

#Energy scale
tDelayData = importedFileCounts[10:,0].astype(np.float)

#If I do not want the data to be fitted then use the fitted data from a previous session!
if FIT_DATA == False:
     results_singleExp_TRPL = np.array(pd.read_csv("Fitting_results_" + fileNameCounts, sep='\t', header=None))
     results_singleExp_TRPL = results_singleExp_TRPL[2:]
     results_singleExp_TRPL = results_singleExp_TRPL.astype(np.float)
     print(results_singleExp_TRPL)



#Loop to fit with the simple model
for i in range (0, importSize):
    
    #If the option was chosen to fit the data then all the spectra are fitted if not then the data was imported
    if FIT_DATA==True:
        #initialize fitting result array
        BestVal_singleExp_TRPL = np.zeros(4)
        
        #Load the to-be-fitted TRPL data, here I pick the base-line corrected data
        data=BScorr_Counts[:,i]
        normdata=BScorr_normCounts[:,i]
        #data = np.divide(data, np.amax(data))
        
    
        try: BestVal_singleExp_TRPL, covar = curve_fit(ExpDecay, tDelayData[FitStartElement:FitEndElement], data[FitStartElement:FitEndElement], p0=InVal_singleExp_TRPL)
        except:
            print("Something happend!")
    
        #Save the NW, subNW, temperature, power, IntTime and the baseline value
        results_singleExp_TRPL[i,0] = NW[i]
        results_singleExp_TRPL[i,1] = NWsub[i]
        results_singleExp_TRPL[i,2] = Temperature[i]
        results_singleExp_TRPL[i,3] = Power[i]
        results_singleExp_TRPL[i,4] = IntTime[i]
        results_singleExp_TRPL[i,5] = Baselines[i]
        #Save the fitting data if I fit 4 parameters:
        #results_singleExp_TRPL[i,5:8] = BestVal_singleExp_TRPL[i]
        #If I fit two parameters:
        results_singleExp_TRPL[i,6:8] = BestVal_singleExp_TRPL
        results_singleExp_TRPL[i,8] = SEt0
        results_singleExp_TRPL[i,9] = SEy0
        
        print("Finished with Temperature: " + str(Temperature[i]) + "sub: " + str(NWsub[i]))
        
        #Do some after processing to get aditional values like width and intensity
        #Determine the intensity
        results_singleExp_TRPL[i,10]=np.trapz(data[IntStartElement:IntEndElement], x=tDelayData[IntStartElement:IntEndElement])
       
        
        
    else:
        #This line is to get the right data selected when the fitting parameters are imported
        data=BScorr_Counts[:,i]
        normdata=BScorr_normCounts[:,i]
        
        
        
    #Choose to print all the spectra
    if PRINT_PLOTS==True:
        #plot the spectra
        plt.figure(figsize=(6, 6))
        #plt.subplot(1, 2, 1)
        plt.semilogy(np.divide(tDelayData,1000), data, 'r')
        plt.semilogy(np.divide(tDelayData,1000), ExpDecay(tDelayData, results_singleExp_TRPL[i,6], results_singleExp_TRPL[i,7], results_singleExp_TRPL[i,8], results_singleExp_TRPL[i,9]), 'b--')
        plt.xlabel("time Delay (ns)")
        plt.ylabel("Intensity (Counts/s)")
        plt.text(13, 40, "NW:           " + str(NW[i]) + "_" + str(NWsub[i]), horizontalalignment='left', verticalalignment='top', fontsize=18)
        plt.text(13, 25, r"$\tau$:               {0:8.3f}".format(np.divide(results_singleExp_TRPL[i,6],1000)) + " ns", horizontalalignment='left', verticalalignment='top', fontsize=15)
        plt.text(13, 15, "Trapz int: {0:8.0f}".format(results_singleExp_TRPL[i,10]) + " a.u.", horizontalalignment='left', verticalalignment='top', fontsize=15)
        plt.text(13, 9, "Baseline:   {0:8.2f}".format(results_singleExp_TRPL[i,5]) + r" $s^{-1}$", horizontalalignment='left', verticalalignment='top', fontsize=15)
        #First two lines that indicate which interval was used for the fitting
        plt.axvline(x=np.divide(tDelayData[FitStartElement],1000),linewidth=1.0, color='g')
        plt.axvline(x=np.divide(tDelayData[FitEndElement],1000),linewidth=1.0, color='g')
        #Then two lines that indicate over which interval I integrate to get the intensity
        plt.axvline(x=np.divide(tDelayData[IntStartElement],1000),linewidth=1.0, color='y')
        plt.axvline(x=np.divide(tDelayData[IntEndElement],1000),linewidth=1.0, color='y')
        plt.axis([10, 18, 0.1, 50])
        #plt.subplot(1, 2, 2)
        #plt.semilogy(tDelayData, normdata, 'r')
        #plt.semilogy(tDelayData, np.divide(biGaussian(tDelayData, BestVal_biGauss_PL[0], BestVal_biGauss_PL[1], BestVal_biGauss_PL[2], BestVal_biGauss_PL[3]),np.amax(data)), 'b--')
        #plt.axvline(x=tDelayData[FitStartElement],linewidth=1.0, color='g')
        #plt.axvline(x=tDelayData[FitEndElement],linewidth=1.0, color='g')
        #plt.axis([0.3, 0.80, 0.001, 1.2])
        plt.savefig('singleExp_TRPL_T='+ str(Temperature[i]) + "_sub="+ str(NWsub[i]) + '.png')
        plt.show()
        
    #break
    
#print(results_singleExp_TRPL)



#create a .txt file with the same name as the h5 file and save in the same location
Header='\r\n'.join(["NW\tNWsub\tTemperature\tPower\tIntTime\tBaseline\ttau\tA\tt0\ty0\tTrapzIntensity", "-\t-\tK\tmW\ts\tcounts/s\tps\tcounts\ts\tcounts\ta.u."])
np.savetxt("Fitting_results_" + fileNameCounts, results_singleExp_TRPL, fmt='%.5e', delimiter='\t', header=Header, newline='\r\n', comments='')
print("Fitting Data saved as: " + "Fitting_results_" + fileNameCounts)


#If more data points are measured per temperature here I average the data to make one point per temp
if SAVE_AVERAGED==True:
    AveragedHeader='\r\n'.join(["NW\tNWsub\tTemperature\tPower\tIntTime\tBaseline\ttau\tA\tt0\ty0\tTrapzIntensity\terrNW\terrNWsub\terrTemperature\terrPower\terrIntTime\terrBaseline\terrtau\terrA\terrt0\terry0\terrTrapzIntensity", "-\t-\tK\tmW\ts\tcounts/s\tps\tcounts\ts\tcounts\ta.u."]) 
    #Sort out which temperatures were measured:
    temperatures=np.unique(results_singleExp_TRPL[:,2], axis=0)
    #To make an array of the right size:
    averaged_results_singleExp_TRPL=np.zeros((np.size(temperatures), results_singleExp_TRPL.shape[1]))
    stdDev_results_singleExp_TRPL=np.zeros((np.size(temperatures), results_singleExp_TRPL.shape[1]))
    #Now loop through all the temperatures and average all the cases found
    n=0
    for temp in temperatures:
        index = np.where(results_singleExp_TRPL[:,2] == temp) #This outputs a list of indices of rows with the same temperature "temp'
        index=index[0]
        print("Temperature: " + str(temp))
        if np.size(index)==0:
            print("An error occured in sorting data")
            break 
        elif np.size(index)==1:
            averaged_results_singleExp_TRPL[n,:] = results_singleExp_TRPL[index,:]
            stdDev_results_singleExp_TRPL[n,:] = np.zeros(results_singleExp_TRPL.shape[1])

        else:
            averaged_results_singleExp_TRPL[n,:] = np.mean(results_singleExp_TRPL[index[0]:(index[-1]+1),:], axis=0)
            stdDev_results_singleExp_TRPL[n,:] =np.std(results_singleExp_TRPL[index[0]:(index[-1]+1),:], axis=0)
        n=n+1
        
    np.savetxt("Averaged_fitting_results_" + fileNameCounts, np.column_stack((averaged_results_singleExp_TRPL, stdDev_results_singleExp_TRPL)), fmt='%.5e', delimiter='\t', header=AveragedHeader, newline='\r\n', comments='')
    print("Averaged Data saved as: " + "Averaged_fitting_results_" + fileNameCounts)






#Plot some overview figures
plt.figure(3, figsize=(20,8))
plt.subplot(1,3,1)
plt.loglog(results_singleExp_TRPL[:,2],np.divide(results_singleExp_TRPL[:,6],1000), "b*", label="LifeTime" )
plt.axis([3, 400, 0.1, 1.0])
plt.xlabel("Temperature (K)")
plt.ylabel("Lifetime (ns)")
plt.legend(loc="best")

plt.subplot(1,3,2)
plt.loglog(results_singleExp_TRPL[:,2],np.divide(results_singleExp_TRPL[:,10],1000), "ro", label="Intensity" )
#plt.loglog(results_singleExp_TRPL[:,2],results_singleExp_TRPL[:,10], "bo", label="Trapz Intensity" )
plt.axis([3, 400, 1, 100])
plt.xlabel("Temperature (K)")
plt.ylabel("Intensity (a.u.)")
plt.legend(loc="best")

plt.subplot(1,3,3)
plt.plot(results_singleExp_TRPL[:,2],results_singleExp_TRPL[:,5], "ro", label="Baseline" )
#plt.loglog(results_singleExp_TRPL[:,2],results_singleExp_TRPL[:,10], "bo", label="Trapz Intensity" )
plt.axis([3, 400, 0, 2])
plt.xlabel("Temperature (K)")
plt.ylabel("Baseline (counts/s)")
plt.legend(loc="best")

plt.savefig('PL_TRPL_Temperature.png')
plt.show()



#Make a second plot with averaged data
plt.figure(4, figsize=(18,6))
plt.subplot(1,3,1)
plt.loglog(averaged_results_singleExp_TRPL[:,2],np.divide(averaged_results_singleExp_TRPL[:,6],1000), "b*", label="LifeTime" )
plt.axis([3, 400, 0.1, 1.0])
plt.xlabel("Temperature (K)")
plt.ylabel("Lifetime (ns)")
plt.legend(loc="best")

plt.subplot(1,3,2)
plt.loglog(averaged_results_singleExp_TRPL[:,2],np.divide(averaged_results_singleExp_TRPL[:,10],1000), "ro", label="Intensity" )
#plt.loglog(results_singleExp_TRPL[:,2],results_singleExp_TRPL[:,10], "bo", label="Trapz Intensity" )
plt.axis([3, 400, 1, 100])
plt.xlabel("Temperature (K)")
plt.ylabel("Intensity (a.u.)")
plt.legend(loc="best")

plt.subplot(1,3,3)
plt.plot(averaged_results_singleExp_TRPL[:,2],averaged_results_singleExp_TRPL[:,5], "ro", label="Baseline" )
#plt.loglog(results_singleExp_TRPL[:,2],results_singleExp_TRPL[:,10], "bo", label="Trapz Intensity" )
plt.axis([3, 400, 0, 2])
plt.xlabel("Temperature (K)")
plt.ylabel("Baseline (counts/s)")
plt.legend(loc="best")

plt.savefig('PL_TRPL_Temperature_averaged.png')
plt.show()

